%Simulate option data for the DMR model; default: T=1 year

%dS_t=beta*(y_t-S_t)*dt+sigma*sqrt(S_t)*dW_t;
%dy_t=xi*(alpha-y_t)*dt+kappa*sqrt(y_t)*dU_t

N_sim=10000000;
T=1; %time to maturity
M=100;delta=T/M;
r=5/100;q=0;

beta=2.575;sigma=3.732;xi=0.446;alpha=19.795;kappa=1.360;

S0=25;
y0=25;
w=normrnd(0,sqrt(delta),[N_sim,M]);u=normrnd(0,sqrt(delta),[N_sim,M]);
S=zeros(N_sim,M+1);y=zeros(N_sim,M+1);
F=zeros(N_sim,M+1);
CF=F;
S(:,1)=S0;y(:,1)=y0;
dd=(beta/(beta-xi))*exp(-xi*(1-0/M)*T)-(xi/(beta-xi))*exp(-beta*(1-0/M)*T);
F(:,1)=alpha+dd*(y(:,1)-alpha)+exp(-beta*(1-0/M)*T)*(S(:,1)-y(:,1));
CF(:,1)=F(:,1)*exp(-r*(1-0/M)*T);

for m=1:M
    y(:,m+1)=y(:,m)+xi*(alpha-y(:,m))*delta+kappa*sqrt(max(0,y(:,m))).*u(:,m);
    S(:,m+1)=S(:,m)+beta*(y(:,m)-S(:,m))*delta+sigma*sqrt(max(0,S(:,m))).*w(:,m);
    dd=(beta/(beta-xi))*exp(-xi*(1-m/M)*T)-(xi/(beta-xi))*exp(-beta*(1-m/M)*T);
    F(:,m+1)=alpha+dd*(y(:,m+1)-alpha)+exp(-beta*(1-m/M)*T)*(S(:,m+1)-y(:,m+1));
    CF(:,m+1)=F(:,m+1)*exp(-r*(1-m/M)*T);
    %disp(F(:,1:10));
end
%disp(F(1:10,:));
disp ("spot price of the future");
disp (CF(1,1));
Spot=CF(1,1);
S=CF; 
S=abs(CF); %avoid a few small non-negative values

 %%   dd=(beta/(beta-xi))*exp(-xi*(1-m/M)*T)-(xi/(beta-xi))*exp(beta*(1-m/M)*T);
 %%   F(:,m)=alpha+dd*(y(:,m)-alpha)+exp(-beta*(1-m/M)*T)*(S(:,m)-y(:,m));

[f,x]=ksdensity(S(1:N_sim,101),0.1:0.1:100);plot(x,f);
%[f,x]=ksdensity(S(1:N_sim,100),0.1:0.1:100);plot(x,f);

Kvec=10:1:50;
Kvec2=50:5:100;
Kvec = unique([Kvec,Kvec2]);
dt = delta; disc = exp(-r*dt);discc = exp(-r*T);
[prices_put, stdErrs_put] = Price_MC_American_Strikes_func(S, disc, 0, Kvec );
% 
 prices_eo_put=Price_MC_EO_Strikes_func(S,discc,0,Kvec);
% 
 [prices_call, stdErrs_call] = Price_MC_American_Strikes_func(S, disc, 1, Kvec );
% 
 prices_eo_call=Price_MC_EO_Strikes_func(S,discc,1,Kvec);
 
 save('DMR_spd_x1y1.mat','prices_put', 'stdErrs_put','prices_eo_put','prices_call', 'stdErrs_call','prices_eo_call','Spot');
 save('DMR_den_x1y1.mat','x','f');